BEGIN

/*===========================
Task 1: Create a Pending Area
===========================*/

dbms_resource_manager.create_pending_area();

/*================================================
Task 2: Create Resource Manager Demonstration Plan
================================================*/

 dbms_resource_manager.create_plan (
 plan    => 'PARALLEL_DEGREE_DEMO',
 comment => 'Parallel Degree Limit Demonstration Plan for AZEROUG'
 );

/*=============================================
Task 3: Create Resource Manager Consumer Groups
=============================================*/

dbms_resource_manager.create_consumer_group (
 consumer_group => 'REPORTING',
 comment        => 'Resource Consumer Group for REPORTING Team'
 );

/*=============================================
Task 4: Create Resource Manager Plan Directives
=============================================*/

 dbms_resource_manager.create_plan_directive (
 plan              => 'PARALLEL_DEGREE_DEMO',
 group_or_subplan  => 'SYS_GROUP',
 comment           => 'Parallel Degree Limit for Administrators Group',
 PARALLEL_DEGREE_LIMIT_P1 => 4
 );

 dbms_resource_manager.create_plan_directive (
 plan              => 'PARALLEL_DEGREE_DEMO',
 group_or_subplan  => 'REPORTING',
 comment           => 'Parallel Degree Limit for REPORTING Group',
 PARALLEL_DEGREE_LIMIT_P1 => 2
 );

 dbms_resource_manager.create_plan_directive (
 plan              => 'PARALLEL_DEGREE_DEMO',
 group_or_subplan  => 'OTHER_GROUPS',
 comment           => 'Parallel Degree Limit for OTHER_GROUPS',
 PARALLEL_DEGREE_LIMIT_P1 => 1
 );

/*=====================================================
Task 5: Create Resource Manager Consumer Group Mappings
=====================================================*/

 dbms_resource_manager.set_consumer_group_mapping (
 attribute      => 'ORACLE_USER',
 value          => 'REPORTING',
 consumer_group => 'REPORTING'
 );

/*==================================
Task 6: Validate/Submit Pending Area
==================================*/

 dbms_resource_manager.validate_pending_area();
 dbms_resource_manager.submit_pending_area();
 
/*===========================
Task 7: Create a Pending Area
===========================*/
 
 dbms_resource_manager.create_pending_area();

/*=======================================
Task 7: Grant Switch Privileges to users
to use Groups as Initial Consumer Group
========================================*/
 
DBMS_RESOURCE_MANAGER_PRIVS.GRANT_SWITCH_CONSUMER_GROUP (
   GRANTEE_NAME   => 'REPORTING',
   CONSUMER_GROUP => 'REPORTING',
   GRANT_OPTION   =>  FALSE
);

DBMS_RESOURCE_MANAGER.SWITCH_PLAN (
   PLAN_NAME=> 'PARALLEL_DEGREE_DEMO'
);

/*==================================
Task 8: Validate/Submit Pending Area
==================================*/

 dbms_resource_manager.validate_pending_area();
 dbms_resource_manager.submit_pending_area();
END;

/
